/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TcpConnectionInfo
implements Cloneable {
    private static final String TRACE_MASKT = "XCDITCDT";
    private static final String TRACE_MASKF = "XCDITCDF";
    private static final String TRACE_MASKD = "XCDITCDD";
    private InetAddress address;
    private int port;
    private String businessUnit;

    public TcpConnectionInfo(String ipAddress, String port) throws UnknownHostException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> TcpConnectionInfo() - " + ipAddress + "," + port);
        if (!this.isAddress(ipAddress)) {
            throw new IllegalArgumentException("Invalid IP address:" + ipAddress);
        }
        this.address = InetAddress.getByName(ipAddress);
        int iPort = 0;
        try {
            iPort = Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("port must be integer:" + port);
        }
        if (iPort < 0 || iPort > 65535) {
            throw new IllegalArgumentException("port out range:" + port);
        }
        this.port = iPort;
        this.businessUnit = "";
        Trace.trace(TRACE_MASKT, "<- TcpConnectionInfo()");
    }

    public TcpConnectionInfo(String ipAddress, String port, String businessUnit) throws UnknownHostException, IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> TcpConnectionInfo() - " + ipAddress + "," + port);
        if (!this.isAddress(ipAddress)) {
            throw new IllegalArgumentException("Invalid IP address:" + ipAddress);
        }
        this.address = InetAddress.getByName(ipAddress);
        int iPort = 0;
        try {
            iPort = Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("port must be integer:" + port);
        }
        if (iPort < 0 || iPort > 65535) {
            throw new IllegalArgumentException("port out range:" + port);
        }
        this.port = iPort;
        this.businessUnit = businessUnit == null ? "" : businessUnit;
        Trace.trace(TRACE_MASKT, "<- TcpConnectionInfo()");
    }

    public Object clone() {
        TcpConnectionInfo copy = null;
        try {
            copy = (TcpConnectionInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            copy = null;
            Trace.trace(TRACE_MASKF, " - TcpConnectionInfo.clone() - catch CloneNotSupportedException");
        }
        if (this.address == null) {
            copy.address = null;
        } else {
            try {
                copy.address = InetAddress.getByName(this.getAddressString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        copy.port = this.port;
        copy.businessUnit = new String(this.businessUnit);
        return copy;
    }

    public int hashCode() {
        Trace.trace(TRACE_MASKT, "-> TcpConnectionInfo.hashCode()");
        int hashcode = 0;
        hashcode ^= this.address.hashCode();
        hashcode ^= this.port;
        Trace.trace(TRACE_MASKT, "<- TcpConnectionInfo.hashCode() - " + (hashcode ^= this.businessUnit.hashCode()));
        return hashcode;
    }

    public boolean equals(Object obj) {
        Trace.trace(TRACE_MASKT, "-> TcpConnectionInfo.equals()");
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TcpConnectionInfo it = (TcpConnectionInfo)obj;
        Trace.trace(TRACE_MASKD, "   TcpConnectionInfo.equals() - Base object:\n     " + this.toString());
        Trace.trace(TRACE_MASKD, "   TcpConnectionInfo.equals() - Passed object:\n     " + it.toString());
        boolean same = true;
        if (this.address == null) {
            if (it.address != null) {
                same = false;
            }
        } else if (!this.address.equals(it.address)) {
            same = false;
        }
        if (this.port != it.port) {
            same = false;
        }
        if (!this.businessUnit.equals(it.businessUnit)) {
            same = false;
        }
        Trace.trace(TRACE_MASKT, "<- TcpConnectionInfo.equals() - " + same);
        return same;
    }

    public String toString() {
        return this.address.getHostAddress() + "," + this.port + "," + this.businessUnit;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getAddressString() {
        return this.address.getHostAddress();
    }

    public byte[] getAddressByteArray() {
        return this.address.getAddress();
    }

    public int getPort() {
        return this.port;
    }

    public String getPortString() {
        return Integer.toString(this.port);
    }

    public String getBusinessUnit() {
        return this.businessUnit;
    }

    private boolean isAddress(String address) {
        Trace.trace(TRACE_MASKT, "<> TcpConnectionInfo.isAddress() - " + address);
        boolean result = true;
        if (address == null) {
            result = false;
        } else {
            int hitDots = 0;
            char[] data = address.toCharArray();
            for (int i = 0; result && i < data.length; ++i) {
                char c = data[i];
                if (c < '0' || c > '9') {
                    result = false;
                }
                int b = 0;
                while (c != '.') {
                    if (c < '0' || c > '9') {
                        result = false;
                    }
                    b = b * 10 + c - 48;
                    if (++i >= data.length) break;
                    c = data[i];
                }
                if (b > 255) {
                    result = false;
                }
                ++hitDots;
            }
            if (hitDots != 4 || address.endsWith(".")) {
                result = false;
            }
        }
        Trace.trace(TRACE_MASKT, "<> TcpConnectionInfo.isAddress() - " + result);
        return result;
    }
}

